// CPPgSourcesDropping implementation file
//


#include "wintypes.h"
#include "xmule.h"
#include "PPgSourcesDropping.h"

#include <wx/slider.h>
#include "wx/xrc/xmlres.h"
#include "wx/xrc/xh_all.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#include <wx/notebook.h>
#include <wx/checkbox.h>
#include <wx/textctrl.h>

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked2(x,y) XRCCTRL(*this,#x,y)->GetValue()
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton3(x,y,z) XRCCTRL(*this,#x,z)->SetValue(y)
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)


IMPLEMENT_DYNAMIC_CLASS(CPPgSourcesDropping,wxPanel)


CPPgSourcesDropping::CPPgSourcesDropping(wxWindow* parent)
  : wxPanel(parent,CPPgSourcesDropping::IDD)
{
	// Getting preferences dialog notebook
	wxNotebook* book= (wxNotebook*) parent;

	// Load Sources Dropping panel from xml resource
	wxPanel* page1 = _panel = wxXmlResource::Get()->LoadPanel(this,"DLG_PPG_SOURCES_DROPPING");
	// Add this panel into preferences dialog notebook
	book->AddPage(this,_("Sources Dropping"));

	// looks stupid? it is :)
	SetSize(page1->GetSize().GetWidth(),page1->GetSize().GetHeight()+60);
	page1->SetSize(GetSize());  

}

CPPgSourcesDropping::~CPPgSourcesDropping()
{
}

void CPPgSourcesDropping::Localize(void)
{
}

void CPPgSourcesDropping::LoadSettings(void)
{
	if (app_prefs->prefs->DropNoNeededSources) {
		CheckDlgButton(IDC_ENABLE_AUTO_NNS, true);
	} else {
		CheckDlgButton(IDC_ENABLE_AUTO_NNS, false);
	}
	if (app_prefs->prefs->SwapNoNeededSources) {
	    GetDlgItem(IDC_AUTO_NNS_EXTENDED_RADIO, wxRadioBox)->SetSelection(0);
	} else {
		GetDlgItem(IDC_AUTO_NNS_EXTENDED_RADIO, wxRadioBox)->SetSelection(1);
	}
	if (app_prefs->prefs->DropFullQueueSources) {
		CheckDlgButton(IDC_ENABLE_AUTO_FQS, true);
	} else {
		CheckDlgButton(IDC_ENABLE_AUTO_FQS, false);
	}
	if (app_prefs->prefs->DropHighQueueRankingSources) {
		CheckDlgButton(IDC_ENABLE_AUTO_HQRS, true);
	} else {
		CheckDlgButton(IDC_ENABLE_AUTO_HQRS, false);
	}

	CString strBuffer;
	strBuffer.Format("%d", app_prefs->prefs->HighQueueRanking);
	GetDlgItem(IDC_HQR_VALUE, wxTextCtrl)->SetValue(strBuffer);

	strBuffer.Format("%d", app_prefs->prefs->AutoDropTimer);
	GetDlgItem(IDC_AUTO_DROP_TIMER, wxTextCtrl)->SetValue(strBuffer);

}

void CPPgSourcesDropping::OnApply()
{
	wxString buffer;
	app_prefs->prefs->DropNoNeededSources = GetDlgItem(IDC_ENABLE_AUTO_NNS, wxCheckBox)->GetValue();
	app_prefs->prefs->SwapNoNeededSources = (GetDlgItem(IDC_AUTO_NNS_EXTENDED_RADIO, wxRadioBox)->GetSelection() == 0);
	app_prefs->prefs->DropFullQueueSources = GetDlgItem(IDC_ENABLE_AUTO_FQS, wxCheckBox)->GetValue();
	app_prefs->prefs->DropHighQueueRankingSources = GetDlgItem(IDC_ENABLE_AUTO_HQRS, wxCheckBox)->GetValue();

	CString strBuffer;
	/* Get the Queue Ranking from dialog. */
	strBuffer.Format("%d", app_prefs->prefs->HighQueueRanking);
	if (GetDlgItem(IDC_HQR_VALUE, wxTextCtrl)->GetValue()) {
		buffer = GetDlgItem(IDC_HQR_VALUE, wxTextCtrl)->GetValue();
		if(atoi(buffer))
		{
			int hqr = atoi(buffer);
			if((hqr <= 3000) && (hqr >= 300)) {
				app_prefs->prefs->HighQueueRanking = hqr;
			} else {
				GetDlgItem(IDC_HQR_VALUE, wxTextCtrl)->SetValue(strBuffer);
			}
		} else {
			GetDlgItem(IDC_HQR_VALUE, wxTextCtrl)->SetValue(strBuffer);
		}
	}
	/* Get the Auto Drop Timer from Dialog */
	strBuffer.Format("%d", app_prefs->prefs->AutoDropTimer);
	if (GetDlgItem(IDC_AUTO_DROP_TIMER, wxTextCtrl)->GetValue()) {
		buffer = GetDlgItem(IDC_AUTO_DROP_TIMER, wxTextCtrl)->GetValue();
		if(atoi(buffer))
		{
			int hqr = atoi(buffer);
			if((hqr <= 3600) && (hqr >= 60)) {
				app_prefs->prefs->AutoDropTimer = hqr;
			} else {
				GetDlgItem(IDC_AUTO_DROP_TIMER, wxTextCtrl)->SetValue(strBuffer);
			}
		} else {
			GetDlgItem(IDC_AUTO_DROP_TIMER, wxTextCtrl)->SetValue(strBuffer);
		}
	}
}
