#ifndef __ADDFILETHREAD_H__
#include "types.h"
#include <wx/thread.h>


class CPartFile;
struct UnknownFile_Struct;

class CAddFileThread : protected wxThread
{
public:
	CAddFileThread();

	static void		Setup();
	static void		Shutdown();

	static void		AddFile(const char *path, const char *name, CPartFile* = NULL);
	static int		GetCount();

protected:
	virtual	BOOL		InitInstance()
		{return true;}
	virtual wxThread::ExitCode 	Entry();
	virtual void 		OnExit()
		{}

private:
	wxThread*		m_Thread;

	// Setted to non-zero to end the thread
	static volatile int	m_endWaitingForHashList;

	// Lock for the wait list and the conditions
	static wxMutex 		m_lockWaitingForHashList;

	// Signaled when something is added to the wait list.
	static wxCondition 	m_runWaitingForHashList;

	// The wait list itself
	static CTypedPtrList<CPtrList, UnknownFile_Struct*>
				m_sWaitingForHashList;
};

#endif

